/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.junit.jupiter;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.support.AnnotationSupport;
import org.mockito.Mockito;
import org.mockito.MockitoSession;
import org.mockito.ScopedMock;
import org.mockito.internal.configuration.plugins.Plugins;
import org.mockito.internal.session.MockitoSessionLoggerAdapter;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.junit.jupiter.resolver.CaptorParameterResolver;
import org.mockito.junit.jupiter.resolver.CompositeParameterResolver;
import org.mockito.junit.jupiter.resolver.MockParameterResolver;
import org.mockito.quality.Strictness;

public class MockitoExtension
implements BeforeEachCallback,
AfterEachCallback,
ParameterResolver {
    private static final ExtensionContext.Namespace MOCKITO = ExtensionContext.Namespace.create("org.mockito");
    private static final String SESSION = "session";
    private static final String MOCKS = "mocks";
    private final Strictness strictness;
    private final ParameterResolver parameterResolver;

    public MockitoExtension() {
        this(Strictness.STRICT_STUBS);
    }

    private MockitoExtension(Strictness strictness) {
        this.strictness = strictness;
        this.parameterResolver = new CompositeParameterResolver(new MockParameterResolver(), new CaptorParameterResolver());
    }

    @Override
    public void beforeEach(ExtensionContext context) {
        List<Object> testInstances = context.getRequiredTestInstances().getAllInstances();
        Strictness actualStrictness = this.retrieveAnnotationFromTestClasses(context).map(MockitoSettings::strictness).orElse(this.strictness);
        MockitoSession session = Mockito.mockitoSession().initMocks(testInstances.toArray()).strictness(actualStrictness).logger(new MockitoSessionLoggerAdapter(Plugins.getMockitoLogger())).startMocking();
        context.getStore(MOCKITO).put(MOCKS, new HashSet());
        context.getStore(MOCKITO).put(SESSION, session);
    }

    private Optional<MockitoSettings> retrieveAnnotationFromTestClasses(ExtensionContext context) {
        Optional<MockitoSettings> annotation;
        ExtensionContext currentContext = context;
        do {
            annotation = AnnotationSupport.findAnnotation(currentContext.getElement(), MockitoSettings.class);
            if (currentContext.getParent().isEmpty()) break;
            currentContext = currentContext.getParent().get();
        } while (annotation.isEmpty() && currentContext != context.getRoot());
        return annotation;
    }

    @Override
    public void afterEach(ExtensionContext context) {
        context.getStore(MOCKITO).remove(MOCKS, Set.class).forEach(mock -> ((ScopedMock)mock).closeOnDemand());
        context.getStore(MOCKITO).remove(SESSION, MockitoSession.class).finishMocking(context.getExecutionException().orElse(null));
    }

    @Override
    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext context) throws ParameterResolutionException {
        return this.parameterResolver.supportsParameter(parameterContext, context);
    }

    @Override
    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext context) throws ParameterResolutionException {
        Object resolvedParameter = this.parameterResolver.resolveParameter(parameterContext, context);
        if (resolvedParameter instanceof ScopedMock) {
            context.getStore(MOCKITO).get(MOCKS, Set.class).add(resolvedParameter);
        }
        return resolvedParameter;
    }
}

