/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.invocation;

import java.util.List;
import org.mockito.ArgumentMatcher;
import org.mockito.internal.invocation.ArgumentMatcherAction;
import org.mockito.invocation.Invocation;

public class MatcherApplicationStrategy {
    private final Invocation invocation;
    private final List<? extends ArgumentMatcher<?>> matchers;

    private MatcherApplicationStrategy(Invocation invocation, List<? extends ArgumentMatcher<?>> matchers) {
        this.invocation = invocation;
        this.matchers = matchers;
    }

    public static MatcherApplicationStrategy getMatcherApplicationStrategyFor(Invocation invocation, List<? extends ArgumentMatcher<?>> matchers) {
        return new MatcherApplicationStrategy(invocation, matchers);
    }

    public boolean forEachMatcherAndArgument(ArgumentMatcherAction action) {
        boolean maybeVararg;
        boolean bl = maybeVararg = this.invocation.getMethod().isVarArgs() && this.invocation.getRawArguments().length == this.matchers.size();
        if (maybeVararg) {
            Class<?> matcherType = this.lastMatcherType();
            Class<?> paramType = this.lastParameterType();
            if (paramType.isAssignableFrom(matcherType)) {
                return this.argsMatch(this.invocation.getRawArguments(), this.matchers, action);
            }
        }
        if (this.invocation.getArguments().length == this.matchers.size()) {
            return this.argsMatch(this.invocation.getArguments(), this.matchers, action);
        }
        return false;
    }

    private boolean argsMatch(Object[] arguments, List<? extends ArgumentMatcher<?>> matchers, ArgumentMatcherAction action) {
        for (int i2 = 0; i2 < arguments.length; ++i2) {
            Object argument;
            ArgumentMatcher<?> matcher = matchers.get(i2);
            if (action.apply(matcher, argument = arguments[i2])) continue;
            return false;
        }
        return true;
    }

    private Class<?> lastMatcherType() {
        return this.matchers.get(this.matchers.size() - 1).type();
    }

    private Class<?> lastParameterType() {
        Class<?>[] parameterTypes = this.invocation.getMethod().getParameterTypes();
        return parameterTypes[parameterTypes.length - 1];
    }
}

