/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.debugging;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.mockito.Mockito;
import org.mockito.invocation.Invocation;
import org.mockito.stubbing.Stubbing;

public class InvocationsPrinter {
    public String printInvocations(Object mock) {
        Collection<Invocation> invocations = Mockito.mockingDetails(mock).getInvocations();
        Collection<Stubbing> stubbings = Mockito.mockingDetails(mock).getStubbings();
        if (invocations.isEmpty() && stubbings.isEmpty()) {
            return "No interactions and stubbings found for mock: " + String.valueOf(mock);
        }
        StringBuilder sb = new StringBuilder();
        int x = 1;
        for (Invocation i2 : invocations) {
            if (x == 1) {
                sb.append("[Mockito] Interactions of: ").append(mock).append("\n");
            }
            sb.append(" ").append(x++).append(". ").append(i2).append("\n");
            sb.append("  ").append(i2.getLocation()).append("\n");
            if (i2.stubInfo() == null) continue;
            sb.append("   - stubbed ").append(i2.stubInfo().stubbedAt()).append("\n");
        }
        List unused = stubbings.stream().filter(stubbing -> !stubbing.wasUsed()).collect(Collectors.toList());
        if (unused.isEmpty()) {
            return sb.toString();
        }
        sb.append("[Mockito] Unused stubbings of: ").append(mock).append("\n");
        x = 1;
        for (Stubbing s : stubbings) {
            sb.append(" ").append(x++).append(". ").append(s.getInvocation()).append("\n");
            sb.append("  - stubbed ").append(s.getInvocation().getLocation()).append("\n");
        }
        return sb.toString();
    }
}

