/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration.injection.filter;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.mockito.internal.configuration.injection.filter.MockCandidateFilter;
import org.mockito.internal.configuration.injection.filter.OngoingInjector;
import org.mockito.internal.exceptions.Reporter;
import org.mockito.internal.util.MockUtil;

public class TypeBasedCandidateFilter
implements MockCandidateFilter {
    private final MockCandidateFilter next;

    public TypeBasedCandidateFilter(MockCandidateFilter next) {
        this.next = next;
    }

    protected boolean isCompatibleTypes(Type typeToMock, Type mockType, Field injectMocksField) {
        boolean result = false;
        if (typeToMock instanceof ParameterizedType) {
            if (mockType instanceof ParameterizedType) {
                if (typeToMock.equals(mockType)) {
                    result = true;
                } else {
                    Type[] actualTypeArguments2;
                    ParameterizedType genericTypeToMock = (ParameterizedType)typeToMock;
                    ParameterizedType genericMockType = (ParameterizedType)mockType;
                    Type[] actualTypeArguments = genericTypeToMock.getActualTypeArguments();
                    result = actualTypeArguments.length == (actualTypeArguments2 = genericMockType.getActualTypeArguments()).length ? this.recurseOnTypeArguments(injectMocksField, actualTypeArguments, actualTypeArguments2) : false;
                }
            } else {
                Class concreteMockClass = (Class)mockType;
                Stream<Type> mockSuperTypes = this.getSuperTypes(concreteMockClass);
                result = mockSuperTypes.anyMatch(mockSuperType -> this.isCompatibleTypes(typeToMock, (Type)mockSuperType, injectMocksField));
            }
        } else if (typeToMock instanceof WildcardType) {
            WildcardType wildcardTypeToMock = (WildcardType)typeToMock;
            Type[] upperBounds = wildcardTypeToMock.getUpperBounds();
            result = Arrays.stream(upperBounds).anyMatch(t -> this.isCompatibleTypes((Type)t, mockType, injectMocksField));
        } else if (typeToMock instanceof Class && mockType instanceof Class) {
            result = ((Class)typeToMock).isAssignableFrom((Class)mockType);
        }
        return result;
    }

    private Stream<Type> getSuperTypes(Class<?> concreteMockClass) {
        Stream<Type> mockInterfaces = Arrays.stream(concreteMockClass.getGenericInterfaces());
        Type genericSuperclass = concreteMockClass.getGenericSuperclass();
        if (genericSuperclass != null) {
            Stream<Type> mockSuperTypes = Stream.concat(mockInterfaces, Stream.of(genericSuperclass));
            return mockSuperTypes;
        }
        return mockInterfaces;
    }

    private boolean recurseOnTypeArguments(Field injectMocksField, Type[] actualTypeArguments, Type[] actualTypeArguments2) {
        boolean isCompatible = true;
        for (int i2 = 0; i2 < actualTypeArguments.length; ++i2) {
            Type actualTypeArgument = actualTypeArguments[i2];
            Type actualTypeArgument2 = actualTypeArguments2[i2];
            if (actualTypeArgument instanceof TypeVariable) {
                TypeVariable typeVariable = (TypeVariable)actualTypeArgument;
                Type genericType = injectMocksField.getGenericType();
                if (genericType instanceof ParameterizedType) {
                    Type[] injectMocksFieldTypeParameters = ((ParameterizedType)genericType).getActualTypeArguments();
                    TypeVariable<Class<?>>[] genericTypeParameters = injectMocksField.getType().getTypeParameters();
                    int variableIndex = -1;
                    for (int i22 = 0; i22 < genericTypeParameters.length; ++i22) {
                        if (!genericTypeParameters[i22].equals(typeVariable)) continue;
                        variableIndex = i22;
                        break;
                    }
                    isCompatible &= this.isCompatibleTypes(injectMocksFieldTypeParameters[variableIndex], actualTypeArgument2, injectMocksField);
                    continue;
                }
                isCompatible &= this.getSuperTypes((Class)genericType).anyMatch(superType -> this.isCompatibleTypes((Type)superType, actualTypeArgument2, injectMocksField));
                continue;
            }
            isCompatible &= this.isCompatibleTypes(actualTypeArgument, actualTypeArgument2, injectMocksField);
        }
        return isCompatible;
    }

    @Override
    public OngoingInjector filterCandidate(Collection<Object> mocks, Field candidateFieldToBeInjected, List<Field> allRemainingCandidateFields, Object injectee, Field injectMocksField) {
        ArrayList<Object> mockTypeMatches = new ArrayList<Object>();
        for (Object mock : mocks) {
            boolean bothHaveTypeInfo;
            if (!candidateFieldToBeInjected.getType().isAssignableFrom(mock.getClass())) continue;
            Type mockType = MockUtil.getMockSettings(mock).getGenericTypeToMock();
            Type typeToMock = candidateFieldToBeInjected.getGenericType();
            boolean bl = bothHaveTypeInfo = typeToMock != null && mockType != null;
            if (bothHaveTypeInfo) {
                if (!this.isCompatibleTypes(typeToMock, mockType, injectMocksField)) continue;
                mockTypeMatches.add(mock);
                continue;
            }
            mockTypeMatches.add(mock);
        }
        boolean wasMultipleMatches = mockTypeMatches.size() > 1;
        OngoingInjector result = this.next.filterCandidate(mockTypeMatches, candidateFieldToBeInjected, allRemainingCandidateFields, injectee, injectMocksField);
        if (wasMultipleMatches && result == OngoingInjector.nop) {
            throw Reporter.moreThanOneMockCandidate(candidateFieldToBeInjected, mocks);
        }
        return result;
    }
}

