/*
 * Decompiled with CFR 0.152.
 */
package ai.evolv;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JsonModifier {
    public static String getVersion() {
        return "1.1";
    }

    public static String modify(String sourceJson, String evolvAllocationResponseJson, String experimentName, String evolvEnv) {
        String experimentSelector;
        Configuration conf = Configuration.defaultConfiguration().addOptions(Option.SUPPRESS_EXCEPTIONS, Option.ALWAYS_RETURN_LIST);
        DocumentContext sourceJsonContext = JsonPath.using(conf).parse(sourceJson);
        DocumentContext evolvAllocationResponseJsonContext = JsonPath.using(conf).parse(evolvAllocationResponseJson);
        List experiments = (List)evolvAllocationResponseJsonContext.read(experimentSelector = "$.[?(@.genome.appPages." + experimentName + ")]", new Predicate[0]);
        if (experiments.isEmpty()) {
            return sourceJson;
        }
        Map experiment = (Map)experiments.get(0);
        Integer ordinalInt = (Integer)experiment.get("ordinal");
        String groupId = (String)experiment.get("group_id");
        String ordinal = ordinalInt.toString();
        String uid = (String)experiment.get("uid");
        String cid = (String)experiment.get("cid");
        String eid = (String)experiment.get("eid");
        System.out.println("ordinal: " + ordinal);
        System.out.println("group_id: " + groupId);
        System.out.println("evolvEnv: " + evolvEnv);
        System.out.println("uid: " + uid);
        System.out.println("cid: " + cid);
        System.out.println("eid: " + eid);
        HashMap<String, Object> globalValues = new HashMap<String, Object>();
        globalValues.put("ordinal", ordinal);
        globalValues.put("group_id", groupId);
        globalValues.put("evolvEnv", evolvEnv);
        globalValues.put("uid", uid);
        globalValues.put("cid", cid);
        globalValues.put("eid", eid);
        List experimentNameAppPage = (List)evolvAllocationResponseJsonContext.read("$..genome.appPages." + experimentName, new Predicate[0]);
        for (Map experimentObject : experimentNameAppPage) {
            for (Map.Entry entry : experimentObject.entrySet()) {
                List jsonObjects;
                List inserts;
                String newValue;
                boolean analyticsProcessed = false;
                System.out.println("Processing: " + (String)entry.getKey());
                Map item = (Map)entry.getValue();
                String objectSelector = (String)item.get("selector");
                Map actions = (Map)item.get("actions");
                System.out.println("Selector: " + objectSelector);
                System.out.println("Actions: " + String.valueOf(actions));
                List updates = (List)actions.get("update");
                if (updates != null) {
                    for (Object update : updates) {
                        String attributeSelector = (String)update.get("selector");
                        newValue = (String)update.get("value");
                        newValue = JsonModifier.interpolate(newValue, globalValues);
                        System.out.println("Update Action Selector: " + attributeSelector);
                        System.out.println("Update Action Value: " + newValue);
                        List jsonObjects2 = (List)sourceJsonContext.read(objectSelector, new Predicate[0]);
                        if (jsonObjects2 == null) continue;
                        Iterator iterator = jsonObjects2.iterator();
                        while (iterator.hasNext()) {
                            Object jsonObject = iterator.next();
                            DocumentContext objectContext = JsonPath.using(conf).parse(jsonObject);
                            objectContext.set(attributeSelector, newValue, new Predicate[0]);
                            sourceJsonContext.set(objectSelector, objectContext.json(), new Predicate[0]);
                        }
                    }
                }
                if ((inserts = (List)actions.get("insert")) != null) {
                    Object update;
                    update = inserts.iterator();
                    while (update.hasNext()) {
                        Map insert = (Map)update.next();
                        newValue = insert.get("value");
                        for (Map.Entry gv : globalValues.entrySet()) {
                            String key = (String)gv.getKey();
                            Object value = gv.getValue();
                            System.out.println("Key: " + key + ", Value: " + String.valueOf(value));
                        }
                        Map<String, Object> newValueMap = JsonModifier.interpolateNested((Map)((Object)newValue), globalValues);
                        jsonObjects = (List)sourceJsonContext.read(objectSelector, new Predicate[0]);
                        if (jsonObjects == null) continue;
                        for (Object jsonObject : jsonObjects) {
                            DocumentContext objectContext = JsonPath.using(conf).parse(jsonObject);
                            for (Map.Entry<String, Object> entry2 : newValueMap.entrySet()) {
                                objectContext.put("$", entry2.getKey(), entry2.getValue(), new Predicate[0]);
                            }
                            sourceJsonContext.set(objectSelector, objectContext.json(), new Predicate[0]);
                        }
                    }
                }
                String analysisNodesToAddString = "{\n    \"vzdl.target.multivariantTest\": \"Combination_${ordinal}:${group_id}\",\n    \"vzdl.target.multivariantTest.list1\": \"Evolv_Combo_${ordinal}:${group_id}\",\n    \"multivariateFeedback\": {\n        \"evolv\": {\n            \"uid\": \"${uid}\",\n            \"cid\": \"${cid}\",\n            \"eid\": \"${eid}\"\n        }\n    }\n}";
                Map analysisNodesToAdd = (Map)JsonPath.parse(analysisNodesToAddString).read("$", new Predicate[0]);
                Map<String, Object> newValueMapSubst = JsonModifier.interpolateNested(analysisNodesToAdd, globalValues);
                String analyticsSelector = (String)item.get("analytics-selector");
                if (analyticsSelector == null || analyticsProcessed) continue;
                analyticsProcessed = true;
                jsonObjects = (List)sourceJsonContext.read(analyticsSelector, new Predicate[0]);
                if (jsonObjects == null) continue;
                for (Object jsonObject : jsonObjects) {
                    DocumentContext analyticsObjectContext = JsonPath.using(conf).parse(jsonObject);
                    for (Map.Entry<String, Object> entryA : newValueMapSubst.entrySet()) {
                        analyticsObjectContext.put("$", entryA.getKey(), entryA.getValue(), new Predicate[0]);
                    }
                    sourceJsonContext.set(analyticsSelector, analyticsObjectContext.json(), new Predicate[0]);
                }
            }
        }
        String modifiedJson = sourceJsonContext.jsonString();
        return modifiedJson;
    }

    public static String interpolate(String template, Map<String, Object> values) {
        String result = template;
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            String placeholder = String.format("${%s}", entry.getKey());
            result = result.replace(placeholder, entry.getValue().toString());
        }
        return result;
    }

    public static Map<String, Object> interpolateNested(Map<String, Object> map, Map<String, Object> values) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof String) {
                map.put(entry.getKey(), JsonModifier.interpolate((String)value, values));
                continue;
            }
            if (!(value instanceof Map)) continue;
            map.put(entry.getKey(), JsonModifier.interpolateNested((Map)value, values));
        }
        return map;
    }
}

