/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.verification.argumentmatching;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.mockito.ArgumentMatcher;
import org.mockito.internal.matchers.ContainsExtraTypeInfo;

public class ArgumentMatchingTool {
    private ArgumentMatchingTool() {
    }

    public static Integer[] getSuspiciouslyNotMatchingArgsIndexes(List<ArgumentMatcher> matchers, Object[] arguments) {
        if (matchers.size() != arguments.length) {
            return new Integer[0];
        }
        LinkedList<Integer> suspicious = new LinkedList<Integer>();
        int i2 = 0;
        for (ArgumentMatcher m : matchers) {
            if (m instanceof ContainsExtraTypeInfo && !ArgumentMatchingTool.safelyMatches(m, arguments[i2]) && ArgumentMatchingTool.toStringEquals(m, arguments[i2]) && !((ContainsExtraTypeInfo)((Object)m)).typeMatches(arguments[i2])) {
                suspicious.add(i2);
            }
            ++i2;
        }
        return suspicious.toArray(new Integer[0]);
    }

    public static List<Integer> getNotMatchingArgsIndexes(List<ArgumentMatcher> matchers, Object[] arguments) {
        if (matchers.size() != arguments.length) {
            return Collections.emptyList();
        }
        ArrayList<Integer> nonMatching = new ArrayList<Integer>();
        int i2 = 0;
        for (ArgumentMatcher m : matchers) {
            if (!ArgumentMatchingTool.safelyMatches(m, arguments[i2])) {
                nonMatching.add(i2);
            }
            ++i2;
        }
        return nonMatching;
    }

    private static boolean safelyMatches(ArgumentMatcher m, Object arg) {
        try {
            return m.matches(arg);
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static boolean toStringEquals(ArgumentMatcher m, Object arg) {
        return m.toString().equals(String.valueOf(arg));
    }

    public static Set<String> getNotMatchingArgsWithSameName(List<ArgumentMatcher> matchers, Object[] arguments) {
        HashMap<String, Set> classesHavingSameName = new HashMap<String, Set>();
        for (ArgumentMatcher m : matchers) {
            Object wanted;
            if (!(m instanceof ContainsExtraTypeInfo) || (wanted = ((ContainsExtraTypeInfo)((Object)m)).getWanted()) == null) continue;
            Class<?> wantedClass = wanted.getClass();
            classesHavingSameName.computeIfAbsent(wantedClass.getSimpleName(), className -> new HashSet()).add(wantedClass.getCanonicalName());
        }
        for (Object argument : arguments) {
            if (argument == null) continue;
            Class<?> wantedClass = argument.getClass();
            classesHavingSameName.computeIfAbsent(wantedClass.getSimpleName(), className -> new HashSet()).add(wantedClass.getCanonicalName());
        }
        return classesHavingSameName.entrySet().stream().filter(classEntry -> ((Set)classEntry.getValue()).size() > 1).map(classEntry -> (String)classEntry.getKey()).collect(Collectors.toSet());
    }
}

