/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.creation.bytebuddy;

import java.lang.ref.ReferenceQueue;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.bytebuddy.TypeCache;
import org.mockito.internal.creation.bytebuddy.BytecodeGenerator;
import org.mockito.internal.creation.bytebuddy.MockFeatures;
import org.mockito.mock.SerializableMode;

class TypeCachingBytecodeGenerator
extends ReferenceQueue<ClassLoader>
implements BytecodeGenerator {
    private static final int CACHE_LOCK_SIZE = 16;
    private static final int CACHE_LOCK_MASK = 15;
    private final BytecodeGenerator bytecodeGenerator;
    private final TypeCache<MockitoMockKey> typeCache;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final TypeCachingLock[] cacheLocks;

    public TypeCachingBytecodeGenerator(BytecodeGenerator bytecodeGenerator, boolean weak) {
        this.bytecodeGenerator = bytecodeGenerator;
        this.typeCache = new TypeCache.WithInlineExpunction<MockitoMockKey>(weak ? TypeCache.Sort.WEAK : TypeCache.Sort.SOFT);
        this.cacheLocks = new TypeCachingLock[16];
        for (int i2 = 0; i2 < 16; ++i2) {
            this.cacheLocks[i2] = new TypeCachingLock();
        }
    }

    public <T> Class<T> mockClass(MockFeatures<T> params) {
        this.lock.readLock().lock();
        try {
            Class mockedType = params.mockedType;
            ClassLoader classLoader = mockedType.getClassLoader();
            MockitoMockKey key = new MockitoMockKey(mockedType, params.interfaces, params.serializableMode, params.stripAnnotations);
            Class<?> clazz = this.typeCache.findOrInsert(classLoader, key, () -> this.bytecodeGenerator.mockClass(params), this.getCacheLockForKey(key));
            return clazz;
        }
        catch (IllegalArgumentException exception) {
            Throwable cause = exception.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw exception;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private TypeCachingLock getCacheLockForKey(MockitoMockKey key) {
        int hashCode = key.hashCode();
        hashCode ^= hashCode >>> 16;
        int index = hashCode & 0xF;
        return this.cacheLocks[index];
    }

    @Override
    public void mockClassStatic(Class<?> type) {
        this.bytecodeGenerator.mockClassStatic(type);
    }

    @Override
    public void mockClassConstruction(Class<?> type) {
        this.bytecodeGenerator.mockClassConstruction(type);
    }

    @Override
    public void clearAllCaches() {
        this.lock.writeLock().lock();
        try {
            this.typeCache.clear();
            this.bytecodeGenerator.clearAllCaches();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private static final class TypeCachingLock {
        private TypeCachingLock() {
        }
    }

    private static class MockitoMockKey
    extends TypeCache.SimpleKey {
        private final SerializableMode serializableMode;
        private final boolean stripAnnotations;

        private MockitoMockKey(Class<?> type, Set<Class<?>> additionalType, SerializableMode serializableMode, boolean stripAnnotations) {
            super(type, additionalType);
            this.serializableMode = serializableMode;
            this.stripAnnotations = stripAnnotations;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            MockitoMockKey that = (MockitoMockKey)object;
            return this.stripAnnotations == that.stripAnnotations && this.serializableMode.equals((Object)that.serializableMode);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.stripAnnotations ? 1 : 0);
            result = 31 * result + this.serializableMode.hashCode();
            return result;
        }
    }
}

