/*
 * Decompiled with CFR 0.152.
 */
package ai.evolv;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsonModifier {
    public static String getVersion() {
        return "1.1";
    }

    public static String modify(String sourceJson, String evolvAllocationResponseJson, String experimentName, String evolvEnv) {
        String experimentSelector;
        Configuration conf = Configuration.defaultConfiguration().addOptions(Option.SUPPRESS_EXCEPTIONS, Option.ALWAYS_RETURN_LIST);
        DocumentContext sourceJsonContext = JsonPath.using(conf).parse(sourceJson);
        DocumentContext evolvAllocationResponseJsonContext = JsonPath.using(conf).parse(evolvAllocationResponseJson);
        List experiments = (List)evolvAllocationResponseJsonContext.read(experimentSelector = "$.[?(@.genome.appPages." + experimentName + ")]", new Predicate[0]);
        if (experiments.isEmpty()) {
            return sourceJson;
        }
        Map experiment = (Map)experiments.get(0);
        Integer ordinalInt = (Integer)experiment.get("ordinal");
        String groupId = (String)experiment.get("group_id");
        String ordinal = ordinalInt.toString();
        System.out.println("ordinal: " + ordinal);
        System.out.println("group_id: " + groupId);
        System.out.println("evolvEnv: " + evolvEnv);
        HashMap<String, Object> globalValues = new HashMap<String, Object>();
        globalValues.put("ordinal", ordinal);
        globalValues.put("group_id", groupId);
        globalValues.put("evolvEnv", evolvEnv);
        List experimentNameAppPage = (List)evolvAllocationResponseJsonContext.read("$..genome.appPages." + experimentName, new Predicate[0]);
        for (Map experimentObject : experimentNameAppPage) {
            for (Map.Entry entry : experimentObject.entrySet()) {
                List inserts;
                String newValue;
                Map item = (Map)entry.getValue();
                String objectSelector = (String)item.get("selector");
                Map actions = (Map)item.get("actions");
                List updates = (List)actions.get("update");
                if (updates != null) {
                    for (Map update : updates) {
                        String attributeSelector = (String)update.get("selector");
                        newValue = (String)update.get("value");
                        newValue = JsonModifier.interpolate(newValue, globalValues);
                        List jsonObjects = (List)sourceJsonContext.read(objectSelector, new Predicate[0]);
                        if (jsonObjects == null) continue;
                        for (Object jsonObject : jsonObjects) {
                            DocumentContext objectContext = JsonPath.using(conf).parse(jsonObject);
                            objectContext.set(attributeSelector, newValue, new Predicate[0]);
                            sourceJsonContext.set(objectSelector, objectContext.json(), new Predicate[0]);
                        }
                    }
                }
                if ((inserts = (List)actions.get("insert")) == null) continue;
                for (Map insert : inserts) {
                    newValue = insert.get("value");
                    Map<String, Object> newValueMap = JsonModifier.interpolateNested((Map)((Object)newValue), globalValues);
                    List jsonObjects = (List)sourceJsonContext.read(objectSelector, new Predicate[0]);
                    if (jsonObjects == null) continue;
                    for (Object jsonObject : jsonObjects) {
                        DocumentContext objectContext = JsonPath.using(conf).parse(jsonObject);
                        for (Map.Entry<String, Object> entry2 : newValueMap.entrySet()) {
                            objectContext.put("$", entry2.getKey(), entry2.getValue(), new Predicate[0]);
                        }
                        sourceJsonContext.set(objectSelector, objectContext.json(), new Predicate[0]);
                    }
                }
            }
        }
        String modifiedJson = sourceJsonContext.jsonString();
        return modifiedJson;
    }

    public static String interpolate(String template, Map<String, Object> values) {
        String result = template;
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            String placeholder = String.format("${%s}", entry.getKey());
            result = result.replace(placeholder, entry.getValue().toString());
        }
        return result;
    }

    public static Map<String, Object> interpolateNested(Map<String, Object> map, Map<String, Object> values) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof String) {
                map.put(entry.getKey(), JsonModifier.interpolate((String)value, values));
                continue;
            }
            if (!(value instanceof Map)) continue;
            map.put(entry.getKey(), JsonModifier.interpolateNested((Map)value, values));
        }
        return map;
    }
}

